# 本文档基于 DeepLearning.AI 提供的 "AI Python for Beginners" 课程内容进行本地化修改
# 参考链接：https://www.deeplearning.ai/short-courses/ai-python-for-beginners/
# 本地化修改参考了 Moonshot AI 提供的 Kimi 智能助手服务
# 参考链接：https://kimi.moonshot.cn/
# 本地化过程中会使用到 Kimi API

import os

from openai import OpenAI
# from dotenv import load_dotenv
from IPython.core.display import display, HTML
import csv

####################################################################
# # Get the OpenAI API key from the .env file
# load_dotenv('.env', override=True)
# openai_api_key = os.getenv('OPENAI_API_KEY')
#
# # Set up the OpenAI client
# client = OpenAI(api_key=openai_api_key)
######################## Replaced by: ##############################
with open('API-key.txt', 'r', encoding='utf-8') as file:
    key = file.read()

client = OpenAI(
    api_key = key,
    base_url = "https://api.moonshot.cn/v1",
)
####################################################################

def display_html(html):
    display(HTML(html))

def read_journal(file_path):
    f = open(file_path, "r")
    journal = f.read()
    f.close()
    
    return journal


def print_llm_response(prompt):
    """This function takes as input a prompt, which must be a string enclosed in quotation marks,
    and passes it to Moonshot's v1 model. The function then prints the response of the model.
    """
    try:
        if not isinstance(prompt, str):
            raise ValueError("Input must be a string enclosed in quotes.")
        completion = client.chat.completions.create(
            model="moonshot-v1-8k",
            messages=[
                {
                    "role": "system",
                    "content": "You are a helpful but terse AI assistant who gets straight to the point.",
                },
                {"role": "user", "content": prompt},
            ],
            temperature=0.0,
        )
        response = completion.choices[0].message.content
        print("_"*100)
        print(response)
        print("_"*100)
        print("\n")
    except TypeError as e:
        print("Error:", str(e))


def get_llm_response(prompt):
    """This function takes as input a prompt, which must be a string enclosed in quotation marks,
    and passes it to Moonshot's v1 model. The function then saves the response of the model as
    a string.
    """
    completion = client.chat.completions.create(
        model="moonshot-v1-8k",
        messages=[
            {
                "role": "system",
                "content": "You are a helpful but terse AI assistant who gets straight to the point.",
            },
            {"role": "user", "content": prompt},
        ],
        temperature=0.0,
    )
    response = completion.choices[0].message.content
    return response


def get_chat_completion(prompt, history):
    history_string = "\n\n".join(["\n".join(turn) for turn in history])
    prompt_with_history = f"{history_string}\n\n{prompt}"
    completion = client.chat.completions.create(
        model="moonshot-v1-8k",
        messages=[
            {
                "role": "system",
                "content": "You are a helpful but terse AI assistant who gets straight to the point.",
            },
            {"role": "user", "content": prompt_with_history},
        ],
        temperature=0.0,
    )
    response = completion.choices[0].message.content
    return response

